#include <Liquid_Crystal.h>                               //βιβλιοθήκη οθόνης LCD

LiquidCrystal myLCD(0x27, 16, 2);                         // Διεύθυνση της LCD. Η Σύνδεση πρέπει να γίνει στην θύρα I2C του Arduino

int LiquidLevel_Pin = A0;                                 // Δήλωση της Θύρας σύνδεσης του αισθητήρα στάθμης υγρού
int levelValue;                                           // Δήλωση της μεταβλητής για την αποθήκευση της τιμής του αισθητήρα
int levelPercentage;                                      // Δήλωση της μεταβλητής για την αποθήκευση της στάθμης σε ποσοστό

void setup() 
{
    myLCD.begin();                                        // Εκκίνηση της οθόνης LCD
}

void loop() 
{
    levelValue = analogRead(LiquidLevel_Pin);             // Ανάγνωση της αναλογικής τιμής από τον αισθητήρα (τιμές από 0-1023,  όπου 0: 0V και 1023: 5V)
    
    levelPercentage = map(levelValue, 0, 1023, 0, 100);   // Μετατροπή της τιμής από 0-1023 σε ποσοστό 0-100
    
    myLCD.Text("Level:    ", 0, 0);                           // Εμφάνιση κειμένου στην πρώτη γραμμή
    myLCD.Text(String(levelPercentage).c_str(), 6, 0);    // Εμφάνιση ποσοστού στάθμης
    myLCD.Text("%", 9, 0);                                // Εμφάνιση του συμβόλου %

    delay(1000);                                          // Καθυστέρηση για σταθερότητα
}
